/*****************************************************************************
*  LPC11U6x SCT program
*
*  1. Use SCT timer to generate a 10 msec clock output @ SCT0_OUT0
*  2. SCT_OUT0 is linked to P1_19 (toggles every 10 msec)
*****************************************************************************/
#include "LPC11U6x.h"

extern void SCT0_Init(void);

int main (void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)        // enable clock for IOCON
                               | (1u << 31);       // enable clock for SCT0/1

    LPC_IOCON->PIO1_19 = 0x00000082;               // P1_19 is SCT0_OUT0

    SCT0_Init();                                   // Initialize SCT

    while (1) 
    {
    }
}
